/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.weapon;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_3417;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.definition.weapon.IWeaponAttack;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.upgrades.melee.SweepingEdgeModifier;

public class SweepWeaponAttack
implements IWeaponAttack {
    public static final Loader LOADER = new Loader();
    @VisibleForTesting
    private final float range;

    @Override
    public boolean dealDamage(IToolStackView tool, ToolAttackContext context, float damage) {
        boolean hit = ToolAttackUtil.dealDefaultDamage(context.getAttacker(), context.getTarget(), damage);
        class_1309 attacker = context.getAttacker();
        if (hit && context.isFullyCharged() && !attacker.method_5624() && !context.isCritical() && attacker.method_24828() && attacker.field_5973 - attacker.field_6039 < attacker.method_6029()) {
            double range = this.range + (float)tool.getModifierLevel(TinkerModifiers.expanded.getId());
            double rangeSq = 2.0 + range;
            rangeSq *= rangeSq;
            float sweepDamage = ((SweepingEdgeModifier)TinkerModifiers.sweeping.get()).getSweepingDamage(tool, damage);
            class_1297 target = context.getTarget();
            for (class_1309 aoeTarget : attacker.method_37908().method_18467(class_1309.class, target.method_5829().method_1009(range, 0.25, range))) {
                class_1531 armorStand;
                if (aoeTarget == attacker || aoeTarget == target || attacker.method_5722((class_1297)aoeTarget) || aoeTarget instanceof class_1531 && (armorStand = (class_1531)aoeTarget).method_6912() || !(attacker.method_5858((class_1297)aoeTarget) < rangeSq)) continue;
                float angle = attacker.method_36454() * ((float)Math.PI / 180);
                aoeTarget.method_6005((double)0.4f, (double)class_3532.method_15374((float)angle), (double)(-class_3532.method_15362((float)angle)));
                ToolAttackUtil.dealDefaultDamage(attacker, (class_1297)aoeTarget, sweepDamage);
            }
            attacker.method_37908().method_43128(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), class_3417.field_14706, attacker.method_5634(), 1.0f, 1.0f);
            if (attacker instanceof class_1657) {
                class_1657 player = (class_1657)attacker;
                player.method_7263();
            }
        }
        return hit;
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends IWeaponAttack> getLoader() {
        return LOADER;
    }

    public SweepWeaponAttack(float range) {
        this.range = range;
    }

    public float getRange() {
        return this.range;
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<SweepWeaponAttack> {
        private Loader() {
        }

        @Override
        public SweepWeaponAttack deserialize(JsonObject json) {
            return new SweepWeaponAttack(class_3518.method_15259((JsonObject)json, (String)"range"));
        }

        @Override
        public SweepWeaponAttack fromNetwork(class_2540 buffer) {
            return new SweepWeaponAttack(buffer.readFloat());
        }

        @Override
        public void serialize(SweepWeaponAttack object, JsonObject json) {
            json.addProperty("range", (Number)Float.valueOf(object.range));
        }

        @Override
        public void toNetwork(SweepWeaponAttack object, class_2540 buffer) {
            buffer.writeFloat(object.range);
        }
    }
}

